#ifndef __CIP_H__
#define __CIP_H__

/**
 *
 * \file        cip.h
 *
 * \brief       Header file for Cresnet Over IP
 *
 * \author      Pete McCormick
 *
 * \date        5/25/2008
 *
 * \note        This file should work for DM and IDOCV
 *
 * \note        Some stuff copied from udpserv.h and masterlist.h
 */

#include "nutypedefs.h"
#include "dm_cip.h"

#ifdef __cplusplus
extern "C" {
#endif

////////////////////////////////////////////////////////////////////////////////

// Link Status Values
#define CIP_DNS_LOOKUP                  1000            // indicates that an IP address needs to be assigned
#define CIP_UNKNOWN                     0
#define CIP_ONLINE                      100
#define CIP_OFFLINE                     -1

#define RETRY_COUNT                     18              // retry attempts before  failure
#define RETRY_TOUT                      10              // retransmit timeout in 10 msec ticks (100ms)
#define MAX_OFFLINE_WAIT                -600           // wait so many(abs) retransmit cycles (60 sec)
#define PING_RETRY_TIME                 6000            // time in between ping messages.  (60 secs)
#define CIP_SEND_PIPE_TIMEOUT           500     // timeout for writing to node's output pipe (5s)

#define CIP_SUCCESS                     1
#define CIP_FAILURE                     0

#define CIP_STATIC_MASTER               0x0001      // indicates that the node should be stored in PM
#define CIP_DELETED_ENTRY               0xFFFFFFFF      // indicates that the node is invalid
#define CIP_UDP_PORT                    41794
#define CIP_TCP_PORT                    41794

////////////////////////////////////////////////////////////////////////////////

#ifdef __cplusplus
}
#endif

#endif


